//
//  WXKLightMail.m
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/08/28.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKLightMail.h"


@interface WXKLightMail (Private)

- (void)calculateTransientValue;

@end


#pragma mark -


@implementation WXKLightMail

- (void)awakeFromFetch
{
	[super awakeFromFetch];
	
	[self calculateTransientValue];
}

- (NSData *)message
{
	NSData *tempObject;
	
    [self willAccessValueForKey:@"message"];
    tempObject = [self primitiveValueForKey:@"message"];
    [self didAccessValueForKey:@"message"];
	
    return tempObject;
}

- (void)setMessage:(NSData *)value
{
	[self willChangeValueForKey:@"message"];
	[self setPrimitiveValue: value forKey:@"message"];
	[self didChangeValueForKey:@"message"];
	
	[self calculateTransientValue];
}

- (NSString *)from
{
	if ([[self valueForKeyPath:@"folder.order"] intValue] == WXKMailInboxMailBox) {
		return [self valueForKey:@"object"];
	}
	return nil;
}

- (NSString *)to
{
	if ([[self valueForKeyPath:@"folder.order"] intValue] == WXKMailSentMailBox ||
		[[self valueForKeyPath:@"folder.order"] intValue] == WXKMailDraftMailBox) {
		return [self valueForKey:@"object"];
	}
	return nil;
}

@end


#pragma mark -


@implementation WXKLightMail (Private)

- (void)calculateTransientValue
{
	NSData *data = [self valueForKey:@"message"];
	if (data) {
		NSString *string = [[[NSString alloc] initWithData:data encoding:NSShiftJISStringEncoding] autorelease];
		if (string) {
			[self setValue:string forKey:@"body"];
			
			unsigned lineStart, contentsEnd;
			[string getLineStart:&lineStart end:NULL contentsEnd:&contentsEnd forRange:NSMakeRange(0, 0)];
			NSString *firstLine = [string substringWithRange:NSMakeRange(lineStart, contentsEnd - lineStart)];
			[self setValue:firstLine forKey:@"subject"];
		}
	}
}

@end
